﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using Advent.aiDevices;

namespace Advent.Controls
{
    public partial class PulseDialing : UserControl
    {
        private PulseDialingGenerator Gen;


        public PulseDialing()
        {
            InitializeComponent();
            this.EnabledChanged += new EventHandler(PulseDialing_EnabledChanged);
        }

        void PulseDialing_EnabledChanged(object sender, EventArgs e)
        {
            timer_Update.Enabled = this.Enabled;
        }

        public void SetGenerator(PulseDialingGenerator Gen)
        {
            this.Gen = Gen;
        }


        private void btn_Dial_Click(object sender, EventArgs e)
        {
            try
            {
                double Make; double Break; 

                if (!double.TryParse(txt_Break.Text, out Break)) throw new Exception("Invalid break time");
                if (!double.TryParse(txt_Make.Text, out Make)) throw new Exception("Invalid make time");
                if (txt_Digit.Text.Length != 1) throw new Exception("You must supply a digit to dial");

                Gen.Generate(new PulseDialingDigit(txt_Digit.Text[0], TimeInterval.InMilliseconds(Make), TimeInterval.InMilliseconds(Break)));

            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }

        }

        private void timer_Update_Tick(object sender, EventArgs e)
        {
            try
            {
                if (Gen == null) return;

                if (Gen.IsActive)
                {
                    gb_PulseDial.Text = "Pulse Dialing (Active)";
                }
                else
                {
                    gb_PulseDial.Text = "Pulse Dialing";
                }


            }
            catch { }
        }
    }
}
